Scriptname zBFSEffectsDeadScript extends activemagiceffect  

GlobalVariable property BFSEffectsActivated auto
GlobalVariable property BFSEffectsDebug auto
GlobalVariable property BFSEffectsZombies auto

Spell property BFSDeadSpell auto
Spell property BFSDeadFireSpell auto
Spell property BFSDeadIceSpell auto
Spell property BFSDeadShockSpell auto
Spell property BFSDeadSteamSpell auto
Spell property BFSDeadPoisonSpell auto
Spell property BFSDeadShaderSpell auto
Spell property BFSConvulseSpell auto

EffectShader property BurnedTexture auto
EffectShader property FireEffectShader auto
EffectShader property FireEffectShaderBig auto

EffectShader property SmokeFX auto
EffectShader property SmokesmallFX auto

EffectShader property CalcinatedTexture auto
EffectShader property ShockEffectShader auto
EffectShader property ShockEffectShaderSmall auto

EffectShader property IceEffectShader auto
EffectShader property FreezeTexture auto
EffectShader property FreezeTextureInstant auto

EffectShader property SteamFX auto

EffectShader property PoisonTexture auto
EffectShader property PoisonTexture2 auto

Keyword property MagicSummonUndead auto

Actor target
float BFSActive
float BFSDebug
float BFSZombies

Auto STATE BFS
EVENT OnEffectStart(Actor akTarget, Actor akCaster)
    target = akTarget
EndEvent

EVENT OnMagicEffectApply(ObjectReference akCaster, MagicEffect akEffect)
if (BFSEffectsActivated != NONE)
	BFSActive = BFSEffectsActivated.GetValue()
endif
if (BFSEffectsDebug != NONE)
	BFSDebug = BFSEffectsDebug.GetValue()
endif
if (BFSActive == 0 || !akEffect.HasKeyword(MagicSummonUndead) || !target.IsDead())
	;; Don't allow to continue if mod is not active or the effect doesn't have the keyword or is still alive
	return
endif


GoToState("Busy") ; Don't run this function again until it's finished

    if target != NONE && akCaster != NONE && akEffect != NONE
		if (BFSDebug == 1)
			Debug.Notification("BFS reanimate start")
		endif
	RegisterForAnimationEvent(target, "GetupEnd")
    endif

GoToState("BFS") ; The function has finished, so it can be called again

EndEvent
ENDSTATE


EVENT OnAnimationEvent(ObjectReference akSource, string asEventName)
	if ( akSource == target && asEventName == "GetupEnd" )
			if (BFSDebug == 1)
				Debug.Notification("BFS reanimate get up")
			endif
		UnRegisterForAnimationEvent(target, "GetupEnd")
		utility.wait(0.5)
		target.RemoveSpell(BFSDeadSpell)
	endIf
endEvent


EVENT OnEffectFinish(Actor akTarget, Actor akCaster)
	if (BFSDebug == 1)
		Debug.Notification("BFS reanimate finish")
	endif
    ;;; If is not dead means that is resurrected
   if !target.IsDead() && target.Is3DLoaded()
	if (BFSEffectsZombies != NONE)
		BFSZombies = BFSEffectsZombies.GetValue()
	endif
	if (BFSZombies == 0)	;; burned zombies not allowed
		target.RemoveSpell(BFSConvulseSpell)
		BurnedTexture.Stop(target)
		SmokeFX.Stop(target)
		SmokesmallFX.Stop(target)
		FireEffectShader.Stop(target)
		FireEffectShaderBig.Stop(target)

		CalcinatedTexture .Stop(target)
		ShockEffectShader.Stop(target)
		ShockEffectShaderSmall.Stop(target)

		IceEffectShader.Stop(target)
		FreezeTexture.Stop(target)
		FreezeTextureInstant.Stop(target)

		SteamFX.Stop(target)

		PoisonTexture.Stop(target)
		PoisonTexture2.Stop(target)

		target.RemoveSpell(BFSDeadFireSpell)
		target.RemoveSpell(BFSDeadIceSpell)
		target.RemoveSpell(BFSDeadShockSpell)
		target.RemoveSpell(BFSDeadSteamSpell)
		target.RemoveSpell(BFSDeadPoisonSpell)
		target.RemoveSpell(BFSDeadShaderSpell)
	else		;; burned zombies allowed, apply shaders again to override resurrection shader
		if target.HasSpell(BFSDeadFireSpell)
			BurnedTexture.play(target)
		elseif target.HasSpell(BFSDeadShockSpell)
			CalcinatedTexture.play(target)
		elseif target.HasSpell(BFSDeadIceSpell)
			FreezeTexture.play(target)
		elseif target.HasSpell(BFSDeadPoisonSpell)
			target.RemoveSpell(BFSDeadPoisonSpell)		;; Allow poison skin to be applied again
		endif
	endif
   endif
EndEvent


STATE Busy
EVENT OnMagicEffectApply(ObjectReference akCaster, MagicEffect akEffect)
	; Do nothing
EndEvent
ENDSTATE